<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Local Market Insight Report</title>
  <link type="text/css" rel="stylesheet" media="all" href="css/LocalMarketInsightCover.css"/>
</head>
<body>
  <div id="page">

   <div id="header">
   </div><!-- end id="header" -->

   <div id="content">
      <div class="cover-date-background"><img src="img/LMI_Cover_TopBanner.png" alt="Local Market Insight" wdith="540px" height="80px" /></div>
      <div class="cover-date">
        {if $agg_type=="QUARTERLY"}
            {$quarterLong} {$currYear} 
        {else}
            {$currMonthTimestamp|date_format:"%B %Y"}
        {/if}
      </div>
      <div class="cover-reportnames">
         {foreach from=$homeTypes item=homeType}
           {$homeType}<br>
         {/foreach}
      </div>
      <div class="cover-lmi-title"><img src="img/LMI_Cover_Title.png" width="540px" height="80px" alt="Local Market Insight" /></div>
      <div class="cover-location">{$locationName}</div>
   </div><!-- end id="content" -->

   <div id="footer">
    <div id="footer-logo"><img src="img/market_trends_premium.png" width="144px" alt="" /></div>
      {if not isset($personalizedData)}
          {if isset($show_logo_on_cover) && ($show_logo_on_cover)}
            <img src="img/{$mls_logo}" class="mls_logo" width="109" alt="mls-logo" /> 
          {/if}
      {else}
        <div class="cover-personalized">
            <div class="cover-presented">Presented by</div>
            <div class="cover-name">{$personalizedData["first_name"]} {$personalizedData["last_name"]}</div>
            <div class="cover-agency">{$personalizedData["office_name"]}</div>
            <div class="cover-details">
                 {if $personalizedData["email"]!=""}Email: {$personalizedData["email"]}<br/>{/if}
                 {if $personalizedData["primary_phone"]!=""}Phone: {$personalizedData["primary_phone"]}<br/>{/if}
                 {if $personalizedData["web_site"]!=""}Web: {$personalizedData["web_site"]}{/if}
            </div>
        </div><!-- end id="cover-personalized" -->
      {/if}
   </div><!-- end id="footer" -->

  </div><!-- end id="page" -->
</body>
</html>
