<?php

/**
 * Project: RBI PDF Reporting Engine
 * Author: Grant McClure
 * File: index.php
 * Version: 1.0
 */

define('RBI_REPORT_DIR', realpath('.') . "/");
define('SMARTY_DIR', RBI_REPORT_DIR . 'Smarty-3.0.6/libs/');
// include the setup script
include(RBI_REPORT_DIR . 'libs/rbi_report_setup.php');

// create rbiReport object
$rbiReport = new RBI_Report();

// set the current action
if (isset($_SERVER['argv']) && (count($_SERVER['argv'])>= 2)) {
  $action = $_SERVER['argv'][1];
  $loc_type = $_SERVER['argv'][2];
  $loc_id = $_SERVER['argv'][3];
  $time_period = $_SERVER['argv'][4];
  $uid = $_SERVER['argv'][5];
} elseif (isset($_REQUEST['action'])) {
  $action = $_REQUEST['action'];
  $agg_type = $_REQUEST['agg_type'];
  $loc_type = $_REQUEST['loc_type'];
  $loc_id = $_REQUEST['loc_id'];
  $f_id = $_REQUEST['f_id'];
  $time_period = $_REQUEST['time_period'];
  if (isset($_REQUEST['uid'])) {
      $uid = $_REQUEST['uid'];
  } else {
      $uid = null; #12749858781;
  }
} else {
  $action = 'html';
  $agg_type = 'MONTHLY';
  $loc_type = 3;
  $loc_id = 51510;
  $loc_id = 1022;
  $f_id = 1000;
  //$loc_id = 24510;
  //$loc_id = 24043;
  $time_period = 2009;
  $uid = null;
}

if (!(isset($loc_type))) {
  echo "Argument 'loc_type' must have a value";
  exit;
}
if (!(isset($loc_id))) {
  echo "Argument 'loc_id' must have a value";
  exit;
}
if (!(isset($time_period))) {
  echo "Argument 'time_period' must have a value";
  exit;
}

$locationTypes = $rbiReport->getLocationTypes();
foreach($locationTypes as $locationType) {
  if ($locationType["lt_id"]==$loc_type) {
    $lt_desc=$locationType["lt_desc"];	
  }
}
$location = $rbiReport->getLocationData($loc_type, $loc_id);
$loc_id=$location["l_id"];
$l_desc=$location["l_desc"];
$l_sdesc=$location["l_shortname"];
if ($l_sdesc!="") {
  $l_desc = strtoupper($l_sdesc);
}

#$reportDir = RBI_REPORT_DIR . "reports/$time_period/";
#if (!(file_exists($reportDir))) {
#  mkdir($reportDir,0777);
#}
#
$title = "Local Market Insight Report";

$filename = "LMI-" . $lt_desc . "-" . $l_desc . "-" . $time_period;
$filename = preg_replace("/[^A-Za-z0-9-.]/", "", $filename) . ".pdf";
#$filepath = $reportDir . $filename;

switch($action) {
    case 'pdf':
        // submitting a rbiReport entry
        //$rbiReport->outputPdfReport($loc_type, $loc_id, $time_period, $filepath, $title);
        $rbiReport->outputPdfReport($agg_type, $loc_type, $loc_id, $f_id, $time_period, $filename, $title, $uid);
        break;
    case 'html':
    default:
        // viewing the rbiReport
        $rbiReport->outputHtmlReport($agg_type, $loc_type, $loc_id, $f_id, $time_period, $uid);
        break;   
}
