<?php

/**
 * Project: RBI PDF Reporting Engine
 * Author: Grant McClure
 * File: index.php
 * Version: 1.0
 */

define('RBI_REPORT_DIR', '/home/gmcclure/reports/trunk/');
define('SMARTY_DIR', '/home/gmcclure/reports/trunk/Smarty-3.0.6/libs/');

// include the setup script
include(RBI_REPORT_DIR . 'libs/rbi_report_setup.php');

// create rbiReport object
$rbiReport = new RBI_Report();



$time_period=201011;

$reportDir = RBI_REPORT_DIR . "reports/$time_period/";
if (!(file_exists($reportDir))) {
  mkdir($reportDir,0777);
}

$locationTypes = $rbiReport->getLocationTypes();
foreach ($locationTypes as $ltRow) {
  $loc_type=$ltRow["lt_id"];
  $lt_desc=$ltRow["lt_desc"];
  $locations = $rbiReport->GetLocationValues($loc_type);
  foreach ($locations as $lvRow) {
    $loc_id=$lvRow["l_id"];
    $l_desc=$lvRow["l_desc"];
    $l_sdesc=$lvRow["l_shortname"];
    if ($l_sdesc!="") {
      $l_desc = strtoupper($l_sdesc);
    }

    $title = "Monthly Market Statistics – Detailed Report";
    $filename = $lt_desc . "-" . $l_desc . "-" . $time_period;
    $filename = preg_replace("/[^A-Za-z0-9-.]/", "", $filename) . ".pdf";
    $filepath = $reportDir . $filename;

    echo $filename . "\n";
    try {
      $rbiReport->outputPdfReport($loc_type, $loc_id, $time_period, $filepath, $title);
    } catch (Exception $e) {
      echo "Could not create $filename";
    }
  }
}

?>
