<?php
include_once(dirname(__FILE__) . "/../config/settings.php");

function db_init($db_url) {
	$url = parse_url($db_url);
	$url['user'] = urldecode($url['user']);
  $url['pass'] = isset($url['pass']) ? urldecode($url['pass']) : '';
  $url['host'] = urldecode($url['host']);
  $url['path'] = urldecode($url['path']);

  // Allow for non-standard MySQL port.
  if (isset($url['port'])) {
    $url['host'] = $url['host'] .':'. $url['port'];
  }
  // Test connecting to the database.

  $connection = @mysql_connect($url['host'], $url['user'], $url['pass'], TRUE, 2);
	
	if (!$connection || !mysql_select_db(substr($url['path'], 1))) {
		die('Could not connect to database: ' . mysql_error());
	}
	return $connection;
}

function db_query($query) {
	return mysql_query($query);
}

function db_fetch_array($query ){
	$res = mysql_query($query) or die('MYSQL Error: <i>' . mysql_error() . '</i>');
	$retval = array();
	if (mysql_num_rows($res)) {
		while ($row = mysql_fetch_assoc($res)) {
			$retval[] = $row;
		}
	}
	return $retval;
}

function db_fetch_result($query ){
	$res = mysql_query($query) or die('MYSQL Error: <i>' . mysql_error() . '</i>');
	if (!$res) {
    die('Could not query:' . mysql_error());
	}
	if (mysql_num_rows($res)) {
		return mysql_result($res, 0);
	}
	return false;
}


function get_facet_types() {
	return db_fetch_array("select * from facet_types");
}

function get_facet_values(){
	return db_fetch_array("select * from facet_values");
}

function get_clean_fids($fids, $ftid) {
	$q = sprintf("select f_id from facet_values where ft_id = %d and f_id in (%s)", $ftid, $fids);
	$tmp = db_fetch_array($q);
	$retval = array();
	//check if all is selected
	$f = explode(',', $fids);
	if (in_array(1000, $f)) { //yes, add all
		$retval[] = 1000;
	}
	
	if (!empty($tmp)) {
		foreach($tmp as $value) {
			$retval[] = $value['f_id'];
		}
	}
	$retval = array_unique($retval); //cleanup duplicates
	return $retval;
}

function get_facet_names($fids, $ftid) {
	   $tmp = db_fetch_array("select f_id, f_desc from facet_values where f_id in (" . $fids .")");
	
	//$tmp = db_fetch_array("select l_id, l_desc from location_values where l_id in (" . $fids .")");
	//$tmp = db_fetch_array("select f_id, f_desc from facet_values where f_id in (" . $fids .") and ft_id =" . $ftid);
	$retval = array();
	if (!empty($tmp)) {
		foreach($tmp as $key=>$value) {
			$retval[$value['f_id']] = $value['f_desc'];
		}
	}
	//print_r($retval);
	return $retval;
}

function get_facet_names_stack($fids, $ftid) {
	$tmp = db_fetch_array("select f_id, f_desc from facet_values where f_id in (" . $fids .") and f_id <> 1000 ");	
	$retval = array();
	if (!empty($tmp)) {
		foreach($tmp as $key=>$value) {
			$retval[$value['f_id']] = $value['f_desc'];
		}
	}
	return $retval;
}

/*
function get_all_metric($col_names, $loc_type, $loc_id, $end_time, $sid) {
     global $report_spans;
	$data_table = $report_spans[$sid]['table'];
     $tmp = db_fetch_array("select %s from `$data_table` " .
									 "where f_id = 1000 and loc_type = %d and loc_id = %d and time_period = %d", 
									$col_names, $loc_type, $loc_id, $end_time);
    $retval = array();	
	foreach($tmp as $val) {
		$retval[] = $val[$col_names];
	}
	return $retval;

} */

function generate_new_end_time($end_time, $range) {
	$last_end_time = substr((string)$end_time, 0, 4) . '-' . substr((string)$end_time, 4, 2);
	$new_date = date('Ym', strtotime('-' . (string)($range) . ' month ' . $last_end_time));	
	return (int)$new_date;
}


function generate_new_end_time_period($end_time, $sid) {
     global $report_spans;
	$data_table = $report_spans[$sid]['table'];
	//$tmp = db_fetch_result("SELECT MAX(time_period) from facet_quarterly", $end_time);  //compute max
	//print '<pre>';
	//print_r($tmp) . ',';
	$retval = db_fetch_result("SELECT MAX(time_period) from $data_table where time_period < " . $end_time); //compute max for prev list
	return $retval;

} 


/*
function generate_time_periods($granularity, $end_time) {
	$retval = array();
	$new_end_time = substr((string)$end_time, 0, 4) . '-' . substr((string)$end_time, 4, 2);
	for ($i = $granularity; $i > 0; $i--) {
		$new_date = date('Ym', strtotime('-' . (string)($i - 1) . ' month ' . $new_end_time));
		$retval[] = (int)$new_date;
	}
	print '<pre>';
	print_r($retval);
	exit;
	return $retval;
}
*/


function generate_time_periods($granularity, $end_time, $sid=0) {
	$retval = array();
	global $report_spans;
	$data_table = $report_spans[$sid]['table'];
	
	$tmp = db_fetch_array("select * from (select distinct(time_period) from $data_table where time_period <= $end_time order by time_period desc limit $granularity) as tp order by time_period asc");
	foreach($tmp as $val) {
		$retval[] = $val['time_period'];
	}
	return $retval;
	
	//$new_date = date('Ym', strtotime($val['time_period']));
}


function get_true_location_id($loc_id) {
	$retval = db_fetch_result(sprintf("SELECT l_id from `location_values` where l_id = %d UNION " .
																		"SELECT l_id from `location_values` where l_shortname = '%s'", $loc_id, $loc_id));
	return (count($retval) ? $retval : $loc_id);
}

function validate_end_time($end_time) {
	$end_time *= 1; //make sure its a number
	$end_time = substr((string)$end_time, 0, 6); //kill extra values
	if (strlen($end_time) != 6) {
		$end_time = '';
	}
	
	return $end_time;
}


/* function get_datasets($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug = false) {
	$label = get_facet_names($fids, $ftid);
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from `facet_aggregations`");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time);
	}
	//$time_periods = db_fetch_array($q);
	$retval = array();
	if (!empty($time_periods)) {
		$fid_array = explode(',', $fids);
		$col_array = explode(',', $col_names);
		foreach($time_periods as $value) {
			$q = sprintf("select f_id, %s from `facet_aggregations` " .
									 "where f_id in (%s) and loc_type = %d and loc_id = %d and time_period = %d order by f_id", 
									$col_names, $fids, $loc_type, $loc_id, $value);
			if ($debug) {
				print "<!-- SQL:\"$q\" -->\n";
			}
			$result = db_fetch_array($q);
			$tmp = array();
			$tmp['time_period'] = $value;
			if (!empty($result)) {
				if (count($col_array) > 1) { //multi metrics
					foreach($col_array as $col) {
						$tmp[$col] = ($result[0][$col] ? $result[0][$col] : 0);
					}
				} 
				else {
					foreach($fid_array as $fid) {
						$val = 0;
						foreach($result as $v) {
							if ($v['f_id'] == $fid) {
								$val = ($v[$col_names] ? $v[$col_names] : 0);
								break;
							}
						}
						if ($col_names == 'sld_avg_sp_to_olp_ratio')
								$val *= 100;
						$tmp[$label[$fid]] = $val;
					}
				}
			} 
				else {
					foreach($fid_array as $v) {
						if (count($label[$v])) {
							$tmp[$label[$v]] = 0;
						}
					}
				}
			}
			$retval[] = $tmp;
		}
	}
	return $retval;
}
*/


function get_datasets_mid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug = false, $sid = 0, $mid =0) {
  
    $current_list = get_datasets_sid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug, $sid);
	
	
	if ($mid == 1) {	
	        //print '<pre>';
			global $debug;
			if ($gty > 1) 
				$new_end_time = $current_list[count($current_list) - 2]['time_period'];
			else {
				$new_end_time = $current_list[count($current_list) - 1]['time_period'];
				$new_end_time = generate_new_end_time_period($new_end_time, $sid);
			}
			
			$prev_period_list = get_datasets_sid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $new_end_time, $debug, $sid);
	        $index_offset =  count($current_list) - count($prev_period_list);	
			 //print_r($current_list);
			 //print_r($prev_period_list);
            //print $index_offset;		
            //exit;			
			/* if ($debug) {  
			  print '<pre>';
			  //print $index_offset;
			  print_r($current_list);
			  print_r($prev_period_list);
			} */			
			$final_list = array();
			foreach($current_list as $id=>$val) {
				foreach($val as $idx => $val_val) {
					if ($idx != 'time_period') {
						//*if ($debug) {
						  //print "off/id $index_offset | $id \n";
						  //print_r($val_val); print "\n";
						  //print_r($prev_period_list[$id][$idx]);
						  //print "offset: " . ($index_offset - $id) . "\n";
						  //print "match " . ($index_offset - $id > 0 ? 'TRUE' : 'FALSE') . "\n";
						  //print "prev data [$id][$idx]" . $prev_period_list[$id][$idx] . "\n";
						//exit;
						//} */
						
						if ($index_offset - $id > 0){ 
							$val[$idx] = 0;
						} 
						else {
							 if (empty($prev_period_list[$id - $index_offset][$idx]) || $prev_period_list[$id - $index_offset][$idx] == 0) {
							   $val[$idx] = 0;
							 } else {
							  $cur = $val[$idx];
							  $prev = $prev_period_list[$id - $index_offset][$idx];
							  
							  $val[$idx] = number_format(100 * ($cur - $prev) / $prev, 2);
							  
						
								//print "cur" . ' ' . $cur . "\n";
								//print "id-offset" . '' . ($id - $index_offset) . "\n";
								//print "prev" . ' ' . $prev . "\n";
								//print "val" . ' ' . $val[$idx] . "\n";
							}
						}
					}
				}
			$final_list[] = $val;
			//print_r($val);
			//exit;
		}
		return $final_list;
	} 
	
	elseif ($mid ==2) {	
	        
			global $debug;
			$r = 1;
			
		
				foreach($current_list as $id=>$val) {
					$new_end_time = generate_new_end_time($current_list[$id]['time_period'], $r * 12);	
				}
					
			
			$prev_period_list = get_datasets_sid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $new_end_time, $debug, $sid);
	        $index_offset =  count($current_list) - count($prev_period_list);	
			
			
			// print '<pre>';
		     //print_r($current_list);
			 //print_r($prev_period_list);
			
            //print $index_offset;		
            //exit;			
			/* if ($debug) {  
			  print '<pre>';
			  //print $index_offset;
			  print_r($current_list);
			  print_r($prev_period_list);
			} */			
			$final_list = array();
		
			foreach($current_list as $id=>$val) {
				foreach($val as $idx => $val_val) {
					if ($idx != 'time_period') {
						//*if ($debug) {
						  //print "off/id $index_offset | $id \n";
						  //print_r($val_val); print "\n";
						  //print_r($prev_period_list[$id][$idx]);
						  //print "offset: " . ($index_offset - $id) . "\n";
						  //print "match " . ($index_offset - $id > 0 ? 'TRUE' : 'FALSE') . "\n";
						  //print "prev data [$id][$idx]" . $prev_period_list[$id][$idx] . "\n";
						//exit;
						//} */
						
						if ($index_offset - $id > 0){ 
							$val[$idx] = 0;
						} 
						else {
							 //if (empty($prev_period_list[$id - $index_offset][$idx]) || $prev_period_list[$id - $index_offset][$idx] == 0) {
							 if (empty($prev_period_list[$id][$idx]) || $prev_period_list[$id][$idx] == 0) {  
							   $val[$idx] = 0;
							 } else {
							  $cur = $val[$idx];
							  //$prev = $prev_period_list[$id - $index_offset][$idx];
							  $prev = $prev_period_list[$id][$idx];
							  
							  $val[$idx] = number_format(100 * ($cur - $prev) / $prev, 2);
							  //$val[$idx] = numberormat(
								//print "cur" . ' ' . $cur . "\n";
								//print "id-offset" . '' . ($id - $index_offset) . "\n";
								//print "prev" . ' ' . $prev . "\n";
								//print "val" . ' ' . $val[$idx] . "\n";
								
							}
						}
					}
				}
			$final_list[] = $val;
			//print_r($val);
			//exit;
		}
		//print '<pre>';
	    //print_r($final_list);
	    //exit;
		return $final_list;
		  
	} 
	
	return $current_list;

}

function get_datasets_by_location_comparison_all($column, $fid, $gty, $lc_array, $end_time, $sid=0, $mid) {

    global $report_spans;
	$data_table = $report_spans[$sid]['table'];
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from $data_table");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time, $sid);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time, $sid);
	}
	
	$lids = '(';
	$max = count($lc_array);
	$c = 0;
	foreach($lc_array as $l) {
		$lids .= $l[1];
		if ($c < $max - 1) {
			$lids .= ',';
		}
		$c++;
	}
	$lids .= ')';

	$retval = array();
	foreach($time_periods as $value) {
		$tmp = array();
		$tmp['time_period'] = $value;
		
		$q = sprintf("select %s, loc_type, loc_id from `$data_table` " . "where f_id = 1000 and time_period = %d and loc_id in %s", $column, $value, $lids);
		$result = db_fetch_array($q);

		foreach($lc_array as $lc) {
			$tmp[$lc[1]] = 0;	//assume worst case scenario
			if (!empty($result)) { //access db result if not empty
				foreach($result as $r) {
					if ($r['loc_type'] == $lc[0] && $r['loc_id'] == $lc[1]) { //match?
						$tmp[$lc[1]] = $r[$column]; 
						if ($column == 'sld_avg_sp_to_olp_ratio') 
							$tmp[$lc[1]] *= 100;
						break;
					}
				}
			}
		}
		$retval[] = $tmp;
		
	}
	return $retval;
	
} 	


/*
function get_datasets_percent($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug = false, $sid = 0, $mid, $poa = 0) {

	$current_list = get_datasets_mid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug, $sid, $mid);
  
    print '<pre>';
	print_r($current_list);
	//exit;
	
 
	//if ($poa == 1) {
  
		$against_all = get_datasets_all($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug, $sid, $mid);
   
		print_r($against_all);	
		//print_r($current_list);
        
		$final_list = array();
		foreach($current_list as $id=>$val) {
			foreach($val as $idx => $val_val) {
			//print_r($val);
				
			if ($idx != 'time_period') {
		
				if ($against_all[$id][$idx] == 0) {
						$val[$idx] = 0;
				} else {					
					$cur = $val[$idx];		
					//print_r($cur);	  
					$prev = $against_all[$id][$idx];
					$val[$idx] = number_format(($cur / $prev) * 100, 2);
				}
			}
		}
		
		$final_list[] = $val;
		
	}	
		
		return $final_list;
	//}
	//return 	$current_list;
} */
 
function get_datasets_sid($col_names, $fids, $ftid, $gty, $loc_id, $loc_type, $end_time, $debug = false, $sid = 0) {
	global $report_spans;
	$data_table = $report_spans[$sid]['table'];

	$label = get_facet_names($fids, $ftid);
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from $data_table");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time, $sid);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time, $sid);
	}
	
	//$time_periods = db_fetch_array($q);
	$retval = array();
	if (!empty($time_periods)) {
		$fid_array = explode(',', $fids);
		//print_r($fid_array);
		$col_array = explode(',', $col_names);
		foreach($time_periods as $value) {
			$q = sprintf("select f_id, %s from `$data_table` " .
									 "where f_id in (%s) and loc_type = %d and loc_id = %d and time_period = %d order by f_id", 
									$col_names, $fids, $loc_type, $loc_id, $value);
			if ($debug) {
				print "<!-- SQL:\"$q\" -->\n";
			}
			$result = db_fetch_array($q);
			
			//print_r($result);
			//exit;
			
			$tmp = array();
			$tmp['time_period'] = $value;
			if (!empty($result)) {
				if (count($col_array) > 1) { //multi metrics
					foreach($col_array as $col) {
						$tmp[$col] = ($result[0][$col] ? $result[0][$col] : 0);
					}
				} 
				else {
					foreach($fid_array as $fid) {
						$val = 0;
						foreach($result as $v) {
							if ($v['f_id'] == $fid) {
								$val = ($v[$col_names] ? $v[$col_names] : 0);
								break;
							}
								//print_r($val);
						}
						if ($col_names == 'sld_avg_sp_to_olp_ratio')
								$val *= 100;
						$tmp[$label[$fid]] = $val;
					}
				}
			} else { //load dummy data to generate empty set
				if (count($col_array) > 1) { //multi metrics
					foreach($col_array as $col) {
						$tmp[$col] = 0;
					}
				} 
				else {
					foreach($fid_array as $v) {
						if (count($label[$v])) {
							$tmp[$label[$v]] = 0;
						}
					}
				}
			}
			$retval[] = $tmp;
		}
	
	}

	
/*	print '<pre>';
	print_r($result);
	//print_r($col_array);
	print_r($retval);
		exit;  */
		//print '<pre>';
			//print_r($result);
		//print_r($retval);
	return $retval; 
}


/*
function get_datasets_by_time_comparison($column, $fid, $gty, $range_array, $loc_id, $loc_type, $end_time) {
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from `facet_aggregations`");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time);
	}

	$retval = array();
	foreach($time_periods as $value) {
		$tp = array();
		$tmp = array();
		foreach ($range_array as $range) {
			$tp[] = $value - (100 * $range);
		}
		$tps = implode(',', $tp);
	
		$q = sprintf("select time_period, %s from facet_aggregations where f_id = %d and loc_type = %d and loc_id = %d and time_period in (%s) order by time_period", 
						$column, $fid, $loc_type, $loc_id, $tps);
		$result = db_fetch_array($q);
		
		$tmp['time_period'] = $value;
		foreach ($tp as $v) {	
			$has_value = false;
			foreach($result as $r) {
				if ($v == $r['time_period']) {
					$tmp[substr($v, 0, 4)] = (($column == 'sld_avg_sp_to_olp_ratio') ? $r[$column] * 100 : $r[$column]);
					$has_value = true;
					break;
				}
			}
			if (!$has_value) {	//zerofill
				$tmp[substr($v, 0, 4)] = 0;
			}
		}
		$retval[] = $tmp;
	}
	return $retval;
} */

//time comparison - edited 09182012
function get_datasets_by_time_comparison($column, $fid, $gty, $range_array, $loc_id, $loc_type, $end_time, $sid =0) {

    global $report_spans;
	$data_table = $report_spans[$sid]['table'];
	
	
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from $data_table");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time, $sid);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time, $sid);
	}
	

	$retval = array();
	foreach($time_periods as $value) {
		$tp = array();
		$tmp = array();
		foreach ($range_array as $range) {
			$tp[] = $value - (100 * $range);
		}
		$tps = implode(',', $tp);
	
		$q = sprintf("select time_period, %s from `$data_table` " . "where f_id = %d and loc_type = %d and loc_id = %d and time_period in (%s) order by time_period", 
						$column, $fid, $loc_type, $loc_id, $tps);
		$result = db_fetch_array($q);
		
		$tmp['time_period'] = $value;
		foreach ($tp as $v) {	
			$has_value = false;
			foreach($result as $r) {
				if ($v == $r['time_period']) {
					$tmp[substr($v, 0, 4)] = (($column == 'sld_avg_sp_to_olp_ratio') ? $r[$column] * 100 : $r[$column]);
					$has_value = true;
					break;
				}
			}
			if (!$has_value) {	//zerofill
				$tmp[substr($v, 0, 4)] = 0;
			}
		}
		$retval[] = $tmp;
	}
	return $retval;
}

function get_datasets_by_location_comparison_mid($column, $fid, $gty, $lc_array, $end_time, $sid=0, $mid) {

    $current_list = get_datasets_by_location_comparison($column, $fid, $gty, $lc_array, $end_time, $sid);
	
	if ($mid == 1) {	
	        
			global $debug;
			$new_end_time = $current_list[count($current_list) - 2]['time_period'];
			
			$prev_period_list = get_datasets_by_location_comparison($column, $fid, $gty, $lc_array, $new_end_time, $sid);
	        $index_offset =  count($current_list) - count($prev_period_list);
			
			 // if ($debug) {  
			  // '<pre>';
			 // print $index_offset;
			  //print_r($current_list);
			  //print_r($prev_period_list);
			//}  
			
			$final_list = array();
			foreach($current_list as $id=>$val) {
				foreach($val as $idx => $val_val) {
					if ($idx != 'time_period') {
						//if ($debug) {
						  //print "off/id $index_offset | $id \n";
						  //print_r($val_val); print "\n";
						 // print_r($prev_period_list[$id][$idx]);
						  //print "offset: " . ($index_offset - $id) . "\n";
						 // print "match " . ($index_offset - $id > 0 ? 'TRUE' : 'FALSE') . "\n";
						   // print "prev data [$id][$idx]" . $prev_period_list[$id][$idx] . "\n";
						//exit;
						//} 
						
						if ($index_offset - $id > 0){ 
							$val[$idx] = 0;
						} 
						else {
							 if (empty($prev_period_list[$id - $index_offset][$idx]) || $prev_period_list[$id - $index_offset][$idx] == 0) {
							   $val[$idx] = 0;
							 } else {
								$cur = $val[$idx];
								
							 $prev = $prev_period_list[$id][$idx];
							  
							  $val[$idx] = number_format(100 * ($cur - $prev) / $prev, 2);
								//print "cur" . ' ' . $cur . "\n";
								//$prev = $prev_period_list[$id - $index_offset][$idx];
								//print "id-offset" . '' . ($id - $index_offset) . "\n";
								//print "prev" . ' ' . $prev . "\n";
								//$val[$idx] = number_format(100 * ($cur - $prev) / $prev, 2);
								//print $val[$idx];
							}
						}
					}
				}
			$final_list[] = $val;
			//print_r($column);
			//exit;
		}
		return $final_list;
	} 
	elseif ($mid ==2) {	
	        //print '<pre>';
			global $debug;
			$r = 1;
			
		
				foreach($current_list as $id=>$val) {
					$new_end_time = generate_new_end_time($current_list[$id]['time_period'], $r * 12);
					//print '<pre>';
					//print_r($new_end_time);
					
				}
					
			
			$prev_period_list = get_datasets_by_location_comparison($column, $fid, $gty, $lc_array, $new_end_time, $sid);
	        $index_offset =  count($current_list) - count($prev_period_list);	
			
		     //print_r($current_list);
			 //print_r($prev_period_list);
			
            //print $index_offset;		
            //exit;			
			/* if ($debug) {  
			  print '<pre>';
			  //print $index_offset;
			  print_r($current_list);
			  print_r($prev_period_list);
			} */			
			$final_list = array();
		
			foreach($current_list as $id=>$val) {
				foreach($val as $idx => $val_val) {
					if ($idx != 'time_period') {
						//*if ($debug) {
						  //print "off/id $index_offset | $id \n";
						  //print_r($val_val); print "\n";
						  //print_r($prev_period_list[$id][$idx]);
						  //print "offset: " . ($index_offset - $id) . "\n";
						  //print "match " . ($index_offset - $id > 0 ? 'TRUE' : 'FALSE') . "\n";
						  //print "prev data [$id][$idx]" . $prev_period_list[$id][$idx] . "\n";
						//exit;
						//} */
						
						if ($index_offset - $id > 0){ 
							$val[$idx] = 0;
						} 
						else {
							 //if (empty($prev_period_list[$id - $index_offset][$idx]) || $prev_period_list[$id - $index_offset][$idx] == 0) {
							 if (empty($prev_period_list[$id][$idx]) || $prev_period_list[$id][$idx] == 0) {  
							   $val[$idx] = 0;
							 } else {
							  $cur = $val[$idx];
							  //$prev = $prev_period_list[$id - $index_offset][$idx];
							  $prev = $prev_period_list[$id][$idx];
							  
							  $val[$idx] = number_format(100 * ($cur - $prev) / $prev, 2);
							  	
								//print "cur" . ' ' . $cur . "\n";
								//print "id-offset" . '' . ($id - $index_offset) . "\n";
								//print "prev" . ' ' . $prev . "\n";
								//print "val" . ' ' . $val[$idx] . "\n";
							}
						}
					}
				}
			$final_list[] = $val;
			//print_r($val);
			//exit;
		}
		return $final_list;		  
	} 
	return $current_list;

}
	

function get_datasets_by_location_comparison($column, $fid, $gty, $lc_array, $end_time, $sid=0) {

    global $report_spans;
	$data_table = $report_spans[$sid]['table'];
	if (strlen($end_time) != 6) {
		$end_time = db_fetch_result("SELECT MAX(time_period) from $data_table");
	}
	if ($gty == 'ytd') { //YTD is invoked
		$granularity = (int)substr((string)$end_time, 4, 2);
		$time_periods = generate_time_periods($granularity, $end_time, $sid);
	}
	else {
		$time_periods = generate_time_periods($gty, $end_time, $sid);
	}
	//print '<pre>';
	//print_r($time_periods);
	//exit;
	
	//create inclusion string
	$lids = '(';
	$max = count($lc_array);
	$c = 0;
	foreach($lc_array as $l) {
		$lids .= $l[1];
		if ($c < $max - 1) {
			$lids .= ',';
		}
		$c++;
	}
	$lids .= ')';

	$retval = array();
	foreach($time_periods as $value) {
		$tmp = array();
		$tmp['time_period'] = $value;
		
		$q = sprintf("select %s, loc_type, loc_id from `$data_table` " . "where f_id = %d and time_period = %d and loc_id in %s", $column, $fid, $value, $lids);
		$result = db_fetch_array($q);

		foreach($lc_array as $lc) {
			$tmp[$lc[1]] = 0;	//assume worst case scenario
			if (!empty($result)) { //access db result if not empty
				foreach($result as $r) {
					if ($r['loc_type'] == $lc[0] && $r['loc_id'] == $lc[1]) { //match?
						$tmp[$lc[1]] = $r[$column]; 
						if ($column == 'sld_avg_sp_to_olp_ratio') 
							$tmp[$lc[1]] *= 100;
						break;
					}
				}
			}
		}
		$retval[] = $tmp;
		
	}
	return $retval;
	
} 

/*
function get_location_types() {
	$tmp = db_fetch_array("select * from location_types");
	$retval = array();
	if (!empty($tmp)) {
		foreach($tmp as $key=>$value) {
			$retval[$value['lt_id']] = $value['lt_desc'];
		}
	}
	return $retval;
} */

function get_location_types($lid) {
	$tmp = db_fetch_array(sprintf("select lt_desc from location_types where lt_id = %d", $lid));
	$retval = '';
	if (!empty($tmp)) {
		$retval = $tmp[0]['lt_desc'];
	}
	return $retval;
}

function get_location_values($lt_id) {
	$tmp = db_fetch_array(sprintf("select * from location_values where lt_id = %d", $lt_id));
	$retval = array();
	if (!empty($tmp)) {
		foreach($tmp as $key=>$value) {
			$retval[$value['l_id']] = $value['l_desc'];
		}
	}
	return $retval;
}

function get_location_value_description($lid) {
	$tmp = db_fetch_array(sprintf("select l_desc from location_values where l_id = %d", $lid));
	$retval = '';
	if (!empty($tmp)) {
		$retval = $tmp[0]['l_desc'];
	}
	return $retval;
}

//initialize database
db_init($db_url);
?>