<?php
include_once(dirname(__FILE__) . "/../config/settings.php");
include_once(dirname(__FILE__) . "/../phpexcel/PHPExcel.php");

/*functions*/
function print_x($val) {
	print "<pre>";
	print_r($val);
	print "</pre>";
}						

function split_date($date) {
	$months = array('01'=>'Jan', '02'=>'Feb', '03'=>'Mar', '04'=>'Apr', '05'=>'May', '06'=>'Jun', '07'=>'Jul', '08'=>'Aug', '09'=>'Sep', '10'=>'Oct', '11'=>'Nov', '12'=>'Dec');
	$year = substr($date, 0, 4);
	$tmp = substr($date, 4, 2);
	$month = $months[substr($date, 4, 2)];
	return array('month'=>$month, 'year'=>$year);
}

function custom_date($date, $splitter = ' ') {
	global $sid, $report_spans;	
	$report = $report_spans[$sid]['date_format'];
	$result = eval($report);
	return $result;
}


function custom_date_legend($date, $splitter = ' ') {
	global $sid, $report_spans;
	$report = $report_spans[$sid]['date_format_legend'];
	$result = eval($report);
	return $result;
}

function custom_date_legend_month($date, $splitter = ' ') {
	global $sid, $report_spans;
	$report = $report_spans[$sid]['date_month'];
	$result = eval($report);
	return $result;
}

function custom_date_month($date) {
    global $sid, $report_spans;
	if ($sid == 0){
	$months = array('01'=>'January', '02'=>'February', '03'=>'March', '04'=>'April', '05'=>'May', '06'=>'June', 
									'07'=>'July', '08'=>'August', '09'=>'September', '10'=>'October', '11'=>'November', '12'=>'December');
	$month = $months[substr($date, 4, 2)];
	return $month;
	}
	else {
		return "Q" . substr($date, 4, 1); //. ' ' . substr($date, 0, 4);
	}

}

function metrics_to_facets($rid_array) {
	global $report_details;
	$retval = array();
	foreach($rid_array as $rid) {
		$retval[] = $report_details[$rid]['title'];
	}
	return $retval;
}

function first_selected(&$ite) {
	if ($ite == 0) {
		$ite++;
		return ' selected="selected" ';
	}
	return '';
}

function location_alias_to_id($loc_id) {
	if(!is_int($loc_id)) {//string perhaps
		return (isset($location_aliases[$loc_id]) ? $location_aliases[$loc_id] : 0);
	}
	return 1000;
}

//Excel Stuff
function int26_to_char($int) {
	return chr(ord('A') + $int - 1);
}

function xy_to_rc($row, $col) {
	$cell = int26_to_char($col) . $row;
	return $cell;
}

function export_array_to_excel($array, $report_title, $report_filename, $freezeStart, $prefix, $suffix, $numColumns) {
	$newExcel = new PHPExcel();
	// Set properties
	$newExcel->getProperties()->setCreator("RBIntel")
								 ->setLastModifiedBy("RBIntel")
								 ->setTitle($report_title)
								 ->setSubject("Office 2000 XLS Standard Document")
								 ->setDescription("RBIntel")
								 ->setKeywords("rbintel chart data")
								 ->setCategory("rbintel");
	
	$newExcel->setActiveSheetIndex(0);
	
	$styleArray = array(
		'font' => array(
			'bold' => true
		)
	);
	
	$rowNum = 1;
	foreach($array as $row=>$cols) {
		$colNum = 1;
		
		foreach($cols as $col) {
			$cell = xy_to_rc($rowNum, $colNum);
			
			if ($rowNum >= $freezeStart && $suffix == '%' && $colNum > 1) { //for percentages, its kinda complicated
				$col = $col / 100;
			}
			
			$newExcel->getActiveSheet()->setCellValue($cell, $col);
			if ($rowNum == 1) { //title row
				$newExcel->getActiveSheet()->getStyle($cell)->applyFromArray($styleArray);
			}
			if ($rowNum < $freezeStart - 1 && $colNum == 1) { //title rows
				//$newExcel->getActiveSheet()->mergeCells($cell . ':' . int26_to_char($numColumns) . $rowNum);
				$newExcel->getActiveSheet()->mergeCells($cell . ':H' . $rowNum);
				$newExcel->getActiveSheet()->getStyle($cell)->applyFromArray($styleArray);
			}

			if ($rowNum == $freezeStart - 1) { //content row
				$newExcel->getActiveSheet()->getStyle($cell)->applyFromArray($styleArray);
				$newExcel->getActiveSheet()->getStyle($cell)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
				$newExcel->getActiveSheet()->getColumnDimension(int26_to_char($colNum))->setAutoSize(true);
			} 
			if ($rowNum >= $freezeStart) {
				if ($colNum > 1 && $rowNum >= $freezeStart) {
					if ($suffix == '%') {
						//$newExcel->getActiveSheet()->getStyle($cell)->getNumberFormat()->setFormatCode("00.0 %;(-00.0) %");
						$newExcel->getActiveSheet()->getStyle($cell)->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00);

					} elseif ($prefix == '$') {
						$newExcel->getActiveSheet()->getStyle($cell)->getNumberFormat()->setFormatCode("$ #,##0;$ (-#,##0)");					
					} else{
						$newExcel->getActiveSheet()->getStyle($cell)->getNumberFormat()->setFormatCode("#,##0;(-#,##0)");
					}
				} else {
				//there is no iff
				}
			}
			$colNum++;
		}
		$rowNum++;
	}
	
	$newExcel->getActiveSheet()->freezePane('A' . $freezeStart);
	$newExcel->getActiveSheet()->setTitle($report_title);
	header('Content-Type: application/vnd.ms-excel');
	header('Content-Disposition: attachment;filename="' . $report_filename . '"');
	header('Cache-Control: max-age=0');
	
	$objWriter = PHPExcel_IOFactory::createWriter($newExcel, 'Excel5');
	$objWriter->save('php://output');
	exit;	
}


?>