<?php
include_once($_SERVER['DOCUMENT_ROOT'] . '/db_config.php');

$rid = (!empty($_GET['rid']) ? $_GET['rid'] : 1);

//chart specific
if (!defined('WIDTH')) define('WIDTH', 785);
if (!defined('HEIGHT')) define('HEIGHT', 330);
if (!defined('FOOTER')) define('FOOTER', '© 2014 RealEstate Business Intelligence, LLC. Data Provided by CoreLogic as of Feb 5, 2014');

//comparison mode specific
if (!defined('TIME_COMPARISON')) define('TIME_COMPARISON', 1);
if (!defined('LOCATION_COMPARISON')) define('LOCATION_COMPARISON', 2);


//report modules
$reports = array(
//					0 => 'Select Report Type',
					1 => 'Market Activity',
					2 => 'Pricing Trends',  //Median/Average Sold Price
					3 => 'Days on Market ',  //Average Days on Market
					4 => 'Pricing Ratios ',  //SP to LP Ratio Module
					5 => '$ per SqFt', 
					6 => 'Market Activity (TAX)',
					7 => 'Pricing Trends (TAX)',
					8 => '$ per SqFt (TAX)',
					9 => 'Distressed Inventory (TAX)',
);

///report units
$report_units = array(
					1 => array(0 => array('prefix' => '', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%') ),
					2 => array(0 => array('prefix' => '$', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					3 => array(0 => array('prefix' => '', 'suffix' => ' Days'), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					4 => array(0 => array('prefix' => '', 'suffix' => '%'), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					5 => array(0 => array('prefix' => '$', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%') ),
					6 => array(0 => array('prefix' => '', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					7 => array(0 => array('prefix' => '$', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					8 => array(0 => array('prefix' => '$', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
					9 => array(0 => array('prefix' => '', 'suffix' => ''), 1 => array('prefix' => '', 'suffix' => '%'), 2 => array('prefix' => '', 'suffix' => '%')),
);

//report spans - [sid]
$report_spans = array(
					0 => array('title' => 'Monthly',
							   'table' => 'facet_aggregations', 
							   'date_format' => '$sdate = split_date($date); return $sdate["month"] . $splitter . $sdate["year"];', 'date_format_legend' => '$sdate = split_date($date); return $sdate["month"] . $splitter . $sdate["year"];',
							   'grains_per_year' => 12, 'date_month' => '$sdate = split_date($date); return $sdate["month"];'),
					1 => array('title' => 'Quarterly', 'table' => 'facet_aggregations_quarterly', 
					           'date_format' => 'return "Q" . substr($date, 4, 1) . \' \' . substr($date, 0, 4);', 'date_format_legend' => 'return "Q" . substr($date, 4, 1) . \' \' . substr($date, 2, 2);',
							   'grains_per_year' => 4, 'date_month' => 'return "Q" . substr($date, 4, 1);'),
					2 => array('title' => 'Yearly', 'table' => 'facet_aggregations', 
					           'date_format' => '$sdate = split_date($date); return $sdate["month"] . $splitter . $sdate["year"];', 'date_format_legend' => '$sdate = split_date($date); return $sdate["month"] . $splitter . substr($sdate["year"], 2,2);',
							   'grains_per_year' => 1, 'date_month' => '$sdate = split_date($date); return $sdate["month"];'),
);
//[mid][sid]
$report_labels = array(
                 0 => array(0 => array('label' => ''), 1 => array('label' => '')),
				 1 => array(0 => array('label' => ' - MoM % Change'), 1 => array('label' => ' - QoQ % Change')),
				 2 => array(0 => array('label' => ' - YoY % Change'), 1 => array('label' => ' - YoY % Change')),
); 

//report metrics
// commented out on Feb 14, 2013. New array is being provided by client - Chi
/*$report_details = array(
					1 => array('report' => 1, 'title' => 'Sold Listings', 'column' => 'num_sold_listings'),
					10 => array('report' => 1, 'title' => 'New Pendings', 'column' => 'num_new_pending_listings'),
					11 => array('report' => 1, 'title' => 'Sold versus New Listings', 'column' => 'num_sold_listings + num_new_listings'),
					4 => array('report' => 1, 'title' => 'All Pendings', 'column' => 'num_pending_listings'),
					2 => array('report' => 1, 'title' => 'New Listings', 'column' => 'num_new_listings'),
					3 => array('report' => 1, 'title' => 'Active Listings', 'column' => 'num_active_listings'),
					5 => array('report' => 2, 'title' => 'Avg Sold $ (Sales)', 'column' => 'sld_avg_sp'),
					6 => array('report' => 2, 'title' => 'Med Sold $ (Sales)', 'column' => 'sld_med_sp'),
					7 => array('report' => 3, 'title' => 'Average Days on Market', 'column' => 'sld_avg_dom'),
					8 => array('report' => 3, 'title' => 'Median Days on Market', 'column' => 'sld_med_dom'),
					9 => array('report' => 4, 'title' => 'Average Sale to Original List Price Ratio', 'column' => 'sld_avg_sp_to_olp_ratio'),
					12 => array('report' => 2, 'title' => 'Median List Price (Sales)', 'column' => 'sld_med_lp'),
					13 => array('report' => 2, 'title' => 'Average List Price (Sales)', 'column' => 'sld_avg_lp'),
					14 => array('report' => 2, 'title' => 'Median List Price (New Pendings)', 'column' => 'newpnd_med_lp'),
					15 => array('report' => 2, 'title' => 'Average List Price (New Pendings)', 'column' => 'newpnd_avg_lp'),
					16 => array('report' => 2, 'title' => 'Median List Price (New Listings)', 'column' => 'newlst_med_lp'),
					17 => array('report' => 2, 'title' => 'Average List Price (New Listings)', 'column' => 'newlst_avg_lp'),
					18 => array('report' => 2, 'title' => 'Median List Price (Actives)', 'column' => 'act_med_lp'),
					19 => array('report' => 2, 'title' => 'Average List Price (Actives)', 'column' => 'act_avg_lp'),
					20 => array('report' => 4, 'title' => 'Median Sale to Original List Price Ratio', 'column' => 'sld_med_sp_to_olp_ratio'),
					21 => array('report' => 4, 'title' => 'Median Sale to List Price Ratio', 'column' => 'sld_med_sp_to_lp_ratio'),
					22 => array('report' => 4, 'title' => 'Average Sale to List Price Ratio', 'column' => 'sld_avg_sp_to_lp_ratio'),
					23 => array('report' => 4, 'title' => 'Median Original List Price to List Price Ratio (New Pendings)', 'column' => 'newpnd_med_lp_to_olp_ratio'),
					24 => array('report' => 4, 'title' => 'Average Original List Price to List Price Ratio (New Pendings)', 'column' => 'newpnd_avg_lp_to_olp_ratio'),
					25 => array('report' => 4, 'title' => 'Median Original List Price to List Price Ratio (All Pendings)', 'column' => 'allpnd_med_lp_to_olp_ratio'),
					26 => array('report' => 4, 'title' => 'Average Original List Price to List Price Ratio (All Pendings)', 'column' => 'allpnd_avg_lp_to_olp_ratio'),
					27 => array('report' => 4, 'title' => 'Median Original List Price to List Price Ratio (Active Listings)', 'column' => 'act_med_lp_to_olp_ratio'),
					28 => array('report' => 4, 'title' => 'Average Original List Price to List Price Ratio (Active Listings)', 'column' => 'act_avg_lp_to_olp_ratio'),
                    29 => array('report' => 3, 'title' => 'Median Days on Market (New Pendings)', 'column' => 'newpnd_med_dom'),
					30 => array('report' => 3, 'title' => 'Average Days on Market (New Pendings)', 'column' => 'newpnd_avg_dom'),
					31 => array('report' => 3, 'title' => 'Median Contract to  Settle', 'column' => 'sld_med_contract_to_settle'),
					32 => array('report' => 3, 'title' => 'Average Contract to  Settle', 'column' => 'sld_avg_contract_to_settle'),
					33 => array('report' => 3, 'title' => 'Median Days to Settle', 'column' => 'sld_med_days_to_settle'),
					34 => array('report' => 3, 'title' => 'Average Days to Settle', 'column' => 'sld_avg_days_to_settle'),
					35 => array('report' => 5, 'title' => 'Median Sold $/Sqft', 'column' => 'sld_med_sp_per_sqft'),
					36 => array('report' => 5, 'title' => 'Average Sold $/Sqft', 'column' => 'sld_avg_sp_per_sqft'),
					37 => array('report' => 5, 'title' => 'Median List $/Sqft', 'column' => 'sld_med_lp_per_sqft'),
					38 => array('report' => 5, 'title' => 'Average List $/Sqft', 'column' => 'sld_avg_lp_per_sqft'),
					39 => array('report' => 5, 'title' => 'Median List $/Sqft (New Pendings)', 'column' => 'newpnd_med_lp_per_sqft'),
					40 => array('report' => 5, 'title' => 'Average List $/Sqft (New Pendings)', 'column' => 'newpnd_avg_lp_per_sqft'),
					41 => array('report' => 5, 'title' => 'Median List $/Sqft (All Pendings)', 'column' => 'allpnd_med_lp_per_sqft'),
					42 => array('report' => 5, 'title' => 'Average List $/Sqft (All Pendings)', 'column' => 'allpnd_avg_lp_per_sqft'),
					43 => array('report' => 5, 'title' => 'Median List $/Sqft (New Listings)', 'column' => 'newlst_med_lp_per_sqft'),
					44 => array('report' => 5, 'title' => 'Average List $/Sqft (New Lisitngs)', 'column' => 'newlst_avg_lp_per_sqft'),
					45 => array('report' => 5, 'title' => 'Median List $/Sqft (Active Listings)', 'column' => 'act_med_lp_per_sqft'),
					46 => array('report' => 5, 'title' => 'Average List $/Sqft (Active Lisitngs)', 'column' => 'act_avg_lp_per_sqft'),
										47 => array('report' => 6, 'title' => 'Number of Sales (Tax)', 'column' => 'num_sold_total'),
					48 => array('report' => 7, 'title' => 'Median Sold Price (Tax)', 'column' => 'sld_med_sp'),
					49 => array('report' => 7, 'title' => 'Average Sold Price (Tax)', 'column' => 'sld_avg_sp'),
					50 => array('report' => 7, 'title' => 'Median Home Value (AVM)', 'column' => 'avm_med'),
					51 => array('report' => 7, 'title' => 'Average Home Value (AVM)', 'column' => 'avm_avg'),
					52 => array('report' => 8, 'title' => 'Median Sold $/SqFt (Tax)', 'column' => 'sld_med_sp_per_sqft'),
					53 => array('report' => 8, 'title' => 'Average Sold $/SqFt (Tax)', 'column' => 'sld_avg_sp_per_sqft'),
					54 => array('report' => 9, 'title' => 'Number of Distressed - combined', 'column' => 'num_distressed_total'),
					55 => array('report' => 9, 'title' => 'Number of Pre-foreclosures (Tax)', 'column' => 'num_distressed_preforeclosure'),
					56 => array('report' => 9, 'title' => 'Number of Auctions (Tax)', 'column' => 'num_distressed_auctions'),
					57 => array('report' => 9, 'title' => 'Number of REO (Tax)', 'column' => 'num_distressed_reo'),	
);*/
// new set of chart metrics provided by client as of Feb 14, 2013 - Chi
$report_details = array(
	1 => array('report' => 1, 'title' => 'Closed Sales', 'column' => 'num_sold_listings'),
	10 => array('report' => 1, 'title' => 'New Pendings', 'column' => 'num_new_pending_listings'),
	11 => array('report' => 1, 'title' => 'Sold versus New Listings', 'column' => 'num_sold_listings + num_new_listings'),
	4 => array('report' => 1, 'title' => 'All Pendings', 'column' => 'num_pending_listings'),
	2 => array('report' => 1, 'title' => 'New Listings', 'column' => 'num_new_listings'),
	3 => array('report' => 1, 'title' => 'Active Listings', 'column' => 'num_active_listings'),
	5 => array('report' => 2, 'title' => 'Avg Sale $', 'column' => 'sld_avg_sp'),
	6 => array('report' => 2, 'title' => 'Med Sale $', 'column' => 'sld_med_sp'),
	7 => array('report' => 3, 'title' => 'Avg Days on Market', 'column' => 'sld_avg_dom'),
	8 => array('report' => 3, 'title' => 'Med Days on Market', 'column' => 'sld_med_dom'),
	9 => array('report' => 4, 'title' => 'Avg Sale to Orig List $ Ratio', 'column' => 'sld_avg_sp_to_olp_ratio'),
	12 => array('report' => 2, 'title' => 'Med List $ (Closed)', 'column' => 'sld_med_lp'),
	13 => array('report' => 2, 'title' => 'Avg List $ (Closed)', 'column' => 'sld_avg_lp'),
	14 => array('report' => 2, 'title' => 'Med List $ (New Pendings)', 'column' => 'newpnd_med_lp'),
	15 => array('report' => 2, 'title' => 'Avg List $ (New Pendings)', 'column' => 'newpnd_avg_lp'),
	16 => array('report' => 2, 'title' => 'Med List $ (New Listings)', 'column' => 'newlst_med_lp'),
	17 => array('report' => 2, 'title' => 'Avg List $ (New Listings)', 'column' => 'newlst_avg_lp'),
	18 => array('report' => 2, 'title' => 'Med List $ (Actives)', 'column' => 'act_med_lp'),
	19 => array('report' => 2, 'title' => 'Avg List $ (Actives)', 'column' => 'act_avg_lp'),
	20 => array('report' => 4, 'title' => 'Med Sale to Orig List $ Ratio', 'column' => 'sld_med_sp_to_olp_ratio'),
	21 => array('report' => 4, 'title' => 'Med Sale to List $ Ratio', 'column' => 'sld_med_sp_to_lp_ratio'),
	22 => array('report' => 4, 'title' => 'Avg Sale to List $ Ratio', 'column' => 'sld_avg_sp_to_lp_ratio'),
    	23 => array('report' => 4, 'title' => 'Med List to Orig List $ Ratio (New Pendings)', 'column' => 'newpnd_med_lp_to_olp_ratio'),
    	24 => array('report' => 4, 'title' => 'Avg List to Orig List $ Ratio (New Pendings)', 'column' => 'newpnd_avg_lp_to_olp_ratio'),
    	25 => array('report' => 4, 'title' => 'Med List to Orig List $ Ratio (All Pendings)', 'column' => 'allpnd_med_lp_to_olp_ratio'),
    	26 => array('report' => 4, 'title' => 'Avg List to Orig List $ Ratio (All Pendings)', 'column' => 'allpnd_avg_lp_to_olp_ratio'),
    	27 => array('report' => 4, 'title' => 'Med List to Orig List $ Ratio (Active Listings)', 'column' => 'act_med_lp_to_olp_ratio'),
    	28 => array('report' => 4, 'title' => 'Avg List to Orig List $ Ratio (Active Listings)', 'column' => 'act_avg_lp_to_olp_ratio'),
    	29 => array('report' => 3, 'title' => 'Med Days on Market (New Pendings)', 'column' => 'newpnd_med_dom'),
	30 => array('report' => 3, 'title' => 'Avg Days on Market (New Pendings)', 'column' => 'newpnd_avg_dom'),
	31 => array('report' => 3, 'title' => 'Med Days Contract to Settle', 'column' => 'sld_med_contract_to_settle'),
	32 => array('report' => 3, 'title' => 'Avg Days Contract to Settle', 'column' => 'sld_avg_contract_to_settle'),
	33 => array('report' => 3, 'title' => 'Med Days to Settle', 'column' => 'sld_med_days_to_settle'),
	34 => array('report' => 3, 'title' => 'Avg Days to Settle', 'column' => 'sld_avg_days_to_settle'),
	35 => array('report' => 5, 'title' => 'Med Sale $/Sqft', 'column' => 'sld_med_sp_per_sqft'),
	36 => array('report' => 5, 'title' => 'Avg Sale $/Sqft', 'column' => 'sld_avg_sp_per_sqft'),
	37 => array('report' => 5, 'title' => 'Med List $/Sqft (Closed)', 'column' => 'sld_med_lp_per_sqft'),
	38 => array('report' => 5, 'title' => 'Avg List $/Sqft (Closed)', 'column' => 'sld_avg_lp_per_sqft'),
	39 => array('report' => 5, 'title' => 'Med List $/Sqft (New Pendings)', 'column' => 'newpnd_med_lp_per_sqft'),
	40 => array('report' => 5, 'title' => 'Avg List $/Sqft (New Pendings)', 'column' => 'newpnd_avg_lp_per_sqft'),
	41 => array('report' => 5, 'title' => 'Med List $/Sqft (All Pendings)', 'column' => 'allpnd_med_lp_per_sqft'),
	42 => array('report' => 5, 'title' => 'Avg List $/Sqft (All Pendings)', 'column' => 'allpnd_avg_lp_per_sqft'),
	43 => array('report' => 5, 'title' => 'Med List $/Sqft (New Listings)', 'column' => 'newlst_med_lp_per_sqft'),
	44 => array('report' => 5, 'title' => 'Avg List $/Sqft (New Listings)', 'column' => 'newlst_avg_lp_per_sqft'),
	45 => array('report' => 5, 'title' => 'Med List $/Sqft (Active Listings)', 'column' => 'act_med_lp_per_sqft'),
	46 => array('report' => 5, 'title' => 'Avg List $/Sqft (Active Listings)', 'column' => 'act_avg_lp_per_sqft'),
	47 => array('report' => 6, 'title' => 'Closed Sales (Tax)', 'column' => 'num_sold_total'),
	48 => array('report' => 7, 'title' => 'Med Sale Price (Tax)', 'column' => 'sld_med_sp'),
	49 => array('report' => 7, 'title' => 'Avg Sale Price (Tax)', 'column' => 'sld_avg_sp'),
	50 => array('report' => 7, 'title' => 'Med Home Value (AVM)', 'column' => 'avm_med'),
	51 => array('report' => 7, 'title' => 'Avg Home Value (AVM)', 'column' => 'avm_avg'),
	52 => array('report' => 8, 'title' => 'Med Sale $/SqFt (Tax)', 'column' => 'sld_med_sp_per_sqft'),
	53 => array('report' => 8, 'title' => 'Avg Sale $/SqFt (Tax)', 'column' => 'sld_avg_sp_per_sqft'),
	54 => array('report' => 9, 'title' => 'Number of Distressed - combined', 'column' => 'num_fc_filings_total'),
	55 => array('report' => 9, 'title' => 'Number of Pre-foreclosures (Tax)', 'column' => 'num_fc_filings_preforeclosure'),
	56 => array('report' => 9, 'title' => 'Number of Auctions (Tax)', 'column' => 'num_fc_filings_auctions'),
	57 => array('report' => 9, 'title' => 'Number of REO (Tax)', 'column' => 'num_fc_filings_reo'),	
        58 => array('report' => 3, 'title' => 'Avg Days to Contract (Sales)', 'column' => 'sld_avg_days_to_contract'),	
	59 => array('report' => 3, 'title' => 'Med Days to Contract (Sales)', 'column' => 'sld_med_days_to_contract'),
);

//facet types extras
/*$facet_types_extras = array(
					1 => array('by' => ''),
					2 => array('by' => 'By Home Type'),
					3 => array('by' => 'By List $ Range (High)'), //List $ Range (High)
					4 => array('by' => 'By Sold $ Range (High)'), //Sold $ Range (High) *
					5 => array('by' => 'By DOM Range'), //DOM Range
					6 => array('by' => 'By SqFt Range'), //SqFt Range
					7 => array('by' => 'By # Bedrooms'),
					8 => array('by' => 'By # Bathrooms'),
					9 => array('by' => 'By Distressed State'), // by Bank-Mediated Type
					10 => array('by' => 'By List $ Range (Med)'),
					11 => array('by' => 'By Sold $ Range (Med)'),
					12 => array('by' => 'By List $ Range (Low)'),
					13 => array('by' => 'By Sold $ Range (Low)'),
);*/
$facet_types_extras = array(
	1 => array('by'	=> ''),
	2 => array('by' => 'By Home Type'),
	3 => array('by' => 'By List Price Range'),
	4 => array('by' => 'By Sold Price Range'),
	5 => array('by' => 'By DOM Range'),
	6 => array('by' => 'By SqFt Range'),
	7 => array('by' => 'By # Bedrooms'),
	8 => array('by' => 'By # Bathrooms'),
	9 => array('by' => 'By Distressed State'),
	10 => array('by' => 'By Original List Price Range'),
	13 => array('by' => 'By List Price Range'),
	14 => array('by' => 'By Sold Price Range'),
	15 => array('by' => 'By Original List Price Range')
);

//deprecated
$rid_db_columns = array(
					101 => 'num_sold_listings',
					201 => 'sld_avg_sp',
					301 => 'sld_avg_dom',
					401 => 'sld_avg_sp_to_olp_ratio',
);

//valid facet types per report module
$valid_ftid_per_module = array(
					1 => array(1=>1,2,3,5,6,7,8,9),
					2 => array(1=>1,2,5,6,7,8,9),
					3 => array(1=>1,2,3,6,7,8,9),
					4 => array(1=>1,2,3,5,6,7,8,9),
);

//graph types
$graph_types = array(
					0 => 'Line Chart',
					1 => 'Table Form',
					2 => 'Bar Chart',
					
);						

//graph type visualization api names
$graph_types_values = array(
					0 => 'line',
					1 => 'Table',
					2 => 'column',
					3 => 'area',
					4 => 'column',
					5 => 'column',
					6 => 'area',
					
);								
									
//default colors. first 11 copied off canicdev sample data									
$default_colors = array("001eff", "7400ce", "c600ff", "ff0000", "a40000", "ff6600", "ffc000", "a8ff00", "05c500", "00bfc6", "afafaf",
											  "3366cc", "dc3912", "ff9900", "109618", "990099", "0099c6", "dd4477", "66aa00", "b82e2e", "316395", "994499");

//wkhtmltopdf specific configs
$wkhtmltopdf_path = '/var/www/charting/wkhtmltopdf/wkhtmltopdf-amd64 -q ';
$wkhtmltoimage_path = '/var/www/charting/wkhtmltopdf/wkhtmltoimage-amd64 --javascript-delay 500 ';

$wkhtmltoimage_path2 = '/var/www/charting/wkhtmltopdf/wkhtmltoimage-amd64 --javascript-delay 1000 ';
												
//location shortname to location id
$location_aliases = array(
	'MRIS' => 1000,
	'BM'   => 1001,
	'DC'   => 1002,
	'MS'   => 1003,
	'ES'   => 1004,
	'NR'   => 1005,
	'NV'   => 1006,
	'SR'   => 1007,
	'SM'   => 1008,
	'WR'   => 1009,
);

$disable_chart="";
												
?>
